 

---

# **Chapter 3.3 – Change Management & Stakeholder Buy-In**

**Purpose:** Ensure the human side of the migration is managed as carefully as the technical side, building trust, enthusiasm, and readiness across all levels of the organization.

---

## **Introduction**

Switching from SAP to an open-source ERP is not just a technology change — it’s a **culture and workflow change**. Employees have to adapt to new processes, a new interface, and in many cases, a new way of thinking about data. Without **effective change management**, even the best ERP implementation can fail.

---

## **1. The Psychology of ERP Change**

### 3.3.1 Resistance is Normal

- People are comfortable with SAP even if it’s inefficient.
- Fear of losing control or making mistakes can lead to pushback.

### 3.3.2 The Trust Gap

- Open-source ERP may be perceived as “less professional” by some.
- Education on global adoption and reliability is essential.

### 3.3.3 Role Identity Shift

- Custom workflows may change job responsibilities.
- Some employees may fear automation will reduce their importance.

📊 **Suggested Visual:**

- Change acceptance curve (Denial → Resistance → Exploration → Commitment).

---

## **2. Building a Stakeholder Map**

### 3.3.4 Identify Key Stakeholders

- Executive sponsors (CEO, CFO, CIO).
- Department heads.
- Power users in each business unit.
- External partners affected by the ERP change.

### 3.3.5 Understand Stakeholder Priorities

- CFO → ROI, cost savings.
- CIO → system reliability, security.
- Operations → workflow efficiency.

### 3.3.6 Engagement Plan

- Tailor communication to each group’s priorities.
- Use both group presentations and one-on-one sessions.

📊 **Suggested Table:**

| Stakeholder   | Priority    | Concerns               | Engagement Method           |
|---------------|-------------|------------------------|-----------------------------|
| CFO           | ROI         | Risk of budget overrun | Financial dashboard reviews |
| Sales Manager | Ease of use | Loss of CRM features   | Pilot demo                  |

---

## **3. Communication Strategy**

### 3.3.7 Transparency from Day One

- Announce the change early — don’t surprise employees.
- Share the business reasons behind the migration.

### 3.3.8 Multi-Channel Updates

- Town halls, email newsletters, intranet portal, department meetings.
- Short videos demonstrating benefits.

### 3.3.9 Visualizing the End State

- Show screenshots or demo videos of the new ERP in action.
- Emphasize how processes will be faster/easier.

📊 **Suggested Visual:**

- Timeline infographic showing communication milestones.

---

## **4. Building an ERP Champion Network**

### 3.3.10 Selecting Champions

- Choose influential, respected employees in each department.
- Must be open to technology change and have good communication skills.

### 3.3.11 Champion Responsibilities

- Act as first-line support during training.
- Collect feedback from their teams.
- Model positive attitudes toward the migration.

### 3.3.12 Incentives for Champions

- Recognition, small bonuses, career development opportunities.

---

## **5. Training & Adoption Plan**

### 3.3.13 Role-Based Training

- Customize training for each role — avoid “one size fits all.”
- Examples: Finance team → GL and reporting; Sales team → CRM & order entry.

### 3.3.14 Hands-On Practice

- Sandbox environment available for all users.
- Simulate real transactions they will perform after go-live.

### 3.3.15 Continuous Learning

- Refresher sessions post-go-live.
- Microlearning videos for quick “how-to” support.

📊 **Suggested Table:**

| Role    | Training Focus       | Format       | Duration |
|---------|----------------------|--------------|----------|
| Finance | GL, AP/AR, reporting | Workshop     | 2 days   |
| Sales   | CRM, orders, quotes  | Hands-on lab | 1 day    |

---

## **6. Handling Resistance**

### 3.3.16 Listen Before Persuading

- Acknowledge fears and frustrations.
- Show you are incorporating their feedback.

### 3.3.17 Small Wins

- Implement quick benefits early (e.g., fewer clicks for routine tasks).
- Publicize success stories.

### 3.3.18 Leadership Example

- Executives should actively use and reference the new ERP.

📊 **Suggested Visual:**

- Before/After workflow comparison for a common process.

---

## **7. Measuring Buy-In and Readiness**

### 3.3.19 Surveys & Feedback Loops

- Monthly surveys to gauge comfort levels and concerns.

### 3.3.20 Adoption Metrics

- Login frequency, task completion rates, helpdesk tickets.

### 3.3.21 Adjustments Based on Feedback

- Adapt training and workflows based on real-world usage patterns.

---

## **Conclusion**

Change management is the glue that holds an ERP migration together. Without **stakeholder trust, clear communication, ERP champions, and continuous training**, even a technically flawless migration can fail. The next chapter will focus on the **data migration strategy** — translating your SAP data into your new open-source ERP without losing accuracy or history.

---

 

 